/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.simulation;

import filenet.sim.api.IVWSIMScenario;
import filenet.sim.api.VWSIMSession;
import filenet.sim.api.VWScenarioCollectionDefinition;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.apps.designer.resources.VWSIMResource;
import filenet.sim.toolkit.designer.message.VWSIMDesignerMessagePanel;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.sim.toolkit.utils.VWSIMLauncher;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioCollectionMenu;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;

public class VWScenarioMenuHelper
implements IVWCoordinationEventListener {
    private VWDesignerCoreData m_designerCoreData = null;
    private VWScenarioCollectionDefinition m_scenarioCollectionDef = null;
    private Vector<VWSIMPropertyData> m_propertyDataList = null;
    private VWScenarioCollectionMenu m_scenarioCollectionMenu = null;
    private boolean m_bIsDirty = false;
    private VWSIMDesignerMessagePanel m_messagePanel = null;
    private FileDialog m_saveFileDialog = null;
    private Frame m_parentFrame = null;

    public VWScenarioMenuHelper(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
        try {
            this.m_parentFrame = this.m_designerCoreData.getSessionInfo().getParentFrame();
            this.m_scenarioCollectionMenu = new VWScenarioCollectionMenu(this);
            VWSessionInfo sessionInfo = this.m_designerCoreData.getSessionInfo();
            if (sessionInfo.getParentApplet() != null) {
                VWSIMHelp.init(sessionInfo.getParentApplet());
            } else {
                VWSIMHelp.init((JFrame)sessionInfo.getParentContainer());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_designerCoreData.getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public JMenu getScenarioCollectionMenu() {
        return this.m_scenarioCollectionMenu;
    }

    public VWScenarioCollectionDefinition getScenarioCollectionDefinition() {
        return this.m_scenarioCollectionDef;
    }

    public boolean getIsCollectionDirty() {
        return this.m_bIsDirty;
    }

    public void clearCollectionDirtyFlag() {
        this.m_bIsDirty = false;
    }

    public void setCollectionDirty() {
        this.m_bIsDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewScenario() {
        try {
            try {
                this.m_designerCoreData.displayWaitCursor();
                this.addScenarioDefinition(null, false);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
                Object var3_2 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            Object var3_1 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    public void addLocalScenario() {
        block3: {
            try {
                FileDialog openFileDialog = this.m_designerCoreData.getFileContext().getOpenFileDialog();
                openFileDialog.setFile(VWResource.s_fileOpenFilterNameEsd);
                openFileDialog.setVisible(true);
                String fileToOpen = openFileDialog.getFile();
                if (fileToOpen == null) break block3;
                VWScenarioDefinition newScenarioDef = VWScenarioDefinition.readFromFile(openFileDialog.getDirectory() + fileToOpen);
                if (newScenarioDef != null) {
                    this.addScenarioDefinition(newScenarioDef, true);
                    break block3;
                }
                throw new VWException("vw.toolkit.design.canvas.simulation.NotAEsdFile", "The selected file is not a ESD file.");
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addRepositoryScenario() {
        block15: {
            IVWIDMDocument IDMDoc;
            byte[] fileContents = null;
            InputStream inStream = null;
            IVWIDMItem idmContext = this.m_designerCoreData.getFileContext().getIDMContextItem();
            String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_select_withHK);
            IVWIDMDialog dialog = VWIDMBaseFactory.instance().getBrowseDialog(idmContext, 17, resources[0], null, "ScenarioDefinition");
            dialog.setTitle(VWResource.s_importScenarioFromDMSTitle);
            dialog.setButtonMnemonic(resources[1]);
            dialog.setButtonTooltip(VWResource.s_select);
            int returnVal = dialog.showDialog(this.m_designerCoreData.getParentFrame());
            if (0 == returnVal && (IDMDoc = (IVWIDMDocument)dialog.getSelectedItem()) != null && (fileContents = IDMDoc.getContents()) != null) {
                inStream = new ByteArrayInputStream(fileContents);
                VWScenarioDefinition newScenarioDef = VWScenarioDefinition.read(inStream);
                fileContents = null;
                inStream.close();
                inStream = null;
                if (newScenarioDef != null) {
                    this.addScenarioDefinition(newScenarioDef, true);
                } else {
                    throw new VWException("vw.toolkit.design.canvas.simulation.NotAScenarioDefinition", "The selected file is not a scenario definition.");
                }
            }
            Object var10_10 = null;
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            fileContents = null;
            {
                break block15;
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_FNOpenErrTitle, 1);
                    Object var10_11 = null;
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    fileContents = null;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                fileContents = null;
                throw throwable;
            }
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 700: {
                try {
                    VWWorkflowCollectionDefinition wflCollDef = (VWWorkflowCollectionDefinition)event.getEventParam();
                    this.m_scenarioCollectionDef = new VWScenarioCollectionDefinition(wflCollDef);
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                    this.m_scenarioCollectionDef = new VWScenarioCollectionDefinition();
                }
                this.clearCollectionDirtyFlag();
                this.reinitializeDataItemList();
                this.m_scenarioCollectionMenu.reinitialize();
                break;
            }
            case 725: {
                this.m_scenarioCollectionMenu.reinitialize();
                VWScenarioDefinition scenarioDef = (VWScenarioDefinition)event.getEventParam();
                if (scenarioDef == null) break;
                this.displayScenarioProperties(this.findDataItemInList(scenarioDef.getName()));
                break;
            }
            case 726: 
            case 727: {
                this.m_scenarioCollectionMenu.reinitialize();
                break;
            }
            case 731: {
                VWScenarioDefinition scenarioDef = (VWScenarioDefinition)event.getEventParam();
                if (scenarioDef == null) break;
                this.displayScenarioProperties(this.findDataItemInList(scenarioDef.getName()));
                break;
            }
        }
    }

    protected VWSIMPropertyData[] getScenarioDataItems() {
        if (this.m_propertyDataList != null && this.m_propertyDataList.size() > 0) {
            Object[] dataItems = new VWSIMPropertyData[this.m_propertyDataList.size()];
            this.m_propertyDataList.copyInto(dataItems);
            return dataItems;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayScenarioProperties(VWSIMPropertyData propertyData) {
        try {
            block4: {
                try {
                    this.m_designerCoreData.displayWaitCursor();
                    if (propertyData == null) break block4;
                    this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 730, propertyData);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var4_3 = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                }
            }
            Object var4_2 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    protected void validateScenario(VWSIMPropertyData propertyData) {
        if (propertyData != null) {
            if (this.m_messagePanel == null) {
                this.m_messagePanel = new VWSIMDesignerMessagePanel();
                this.m_messagePanel.init(propertyData, 1);
            }
            this.m_messagePanel.validateScenario(propertyData, true);
        }
    }

    protected void launchScenario(VWSIMPropertyData propertyData) {
        try {
            IVWIDMDocument idmDoc;
            VWSIMSession simSession;
            IVWSIMScenario scenario;
            if (propertyData.getIDMContext() == null) {
                if (!this.performFileNETAddNewItemAction(propertyData)) {
                    return;
                }
            } else if (propertyData.isDirty()) {
                this.performFileNETSaveItemAction(propertyData);
            }
            if (propertyData.getIDMContext() != null && (scenario = (simSession = new VWSIMSession()).getScenario((idmDoc = (IVWIDMDocument)propertyData.getIDMContext()).getLibraryId(), idmDoc.getId())) != null) {
                VWSIMLauncher launcher = new VWSIMLauncher(propertyData);
                boolean bSuccess = launcher.startSimulation(propertyData.getScenarioDefinition(), scenario, propertyData.getIDMContext());
                propertyData.repaintContainer();
                if (bSuccess) {
                    launcher.getSimulation();
                    VWMessageDialog.showOptionDialog(propertyData.getParentFrame(), VWSIMResource.s_simulationStarted, VWSIMResource.s_startSimulationToolTip, 2);
                }
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    protected void copyScenario(VWSIMPropertyData propertyData) throws VWException {
        VWScenarioDefinition scenarioDef = propertyData.getScenarioDefinition();
        VWScenarioDefinition clonedDef = (VWScenarioDefinition)scenarioDef.clone();
        clonedDef.setName(VWResource.s_copyOfFieldName.toString(scenarioDef.getName()));
        this.addScenarioDefinition(clonedDef, false);
    }

    protected void removeScenario(String scenarioName) {
        try {
            VWScenarioDefinition scenarioDef = this.m_scenarioCollectionDef.removeScenario(scenarioName);
            this.removeDataItemFromList(scenarioDef.getName());
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 727, scenarioDef);
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected void saveScenarioToLocal(VWSIMPropertyData propertyData) {
        try {
            VWScenarioDefinition scenarioDef = propertyData.getScenarioDefinition();
            if (scenarioDef == null) {
                return;
            }
            if (this.m_saveFileDialog == null) {
                this.m_saveFileDialog = new FileDialog(this.m_parentFrame);
                this.m_saveFileDialog.setMode(1);
                this.m_saveFileDialog.setTitle(VWResource.s_saveStr);
                this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterNameTemplateEsd.toString(VWResource.s_untitled));
            }
            String savedDir = this.m_saveFileDialog.getDirectory();
            String savedFile = this.m_saveFileDialog.getFile();
            String scenarioName = scenarioDef.getName();
            if (scenarioName != null && scenarioName.length() > 0) {
                this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterNameTemplateEsd.toString(scenarioName));
            }
            this.m_saveFileDialog.setVisible(true);
            if (this.m_saveFileDialog.getFile() == null) {
                this.m_saveFileDialog.setDirectory(savedDir);
                this.m_saveFileDialog.setFile(savedFile);
            } else {
                scenarioDef.writeToFile(this.m_saveFileDialog.getDirectory() + this.m_saveFileDialog.getFile());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean performFileNETAddNewItemAction(VWSIMPropertyData propertyData) {
        bAddNew = true;
        try {
            try {
                propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
                scenarioDefinition = propertyData.getScenarioDefinition();
                if (scenarioDefinition == null) {
                    var4_6 = false;
                    var13_8 = null;
                    propertyData.restoreDefaultCursor();
                    return var4_6;
                }
                name = scenarioDefinition.getName();
                if (name == null) {
                    name = "";
                }
                if ((desc = scenarioDefinition.getDescription()) == null) {
                    desc = "";
                }
                propertyData.displayWaitCursor();
                outStream = new ByteArrayOutputStream();
                scenarioDefinition.write(outStream);
                fileContents = outStream.toByteArray();
                outStream.close();
                parameters = new Hashtable<String, String>();
                parameters.put("DocumentTitle", name);
                parameters.put("ScenarioDescription", desc);
                factory = VWIDMBaseFactory.instance();
                dialog = factory.getAddDialog(propertyData.getParentFrame(), propertyData.getIDMContext(), fileContents, "ScenarioDefinition", parameters);
                dialog.setTitle(factory.getVWString(23).toString());
                dialog.setFilename(name);
                propertyData.restoreDefaultCursor();
                nResult = dialog.showDialog(propertyData.getParentFrame());
                propertyData.repaintContainer();
                switch (nResult) {
                    case 0: {
                        propertyData.resetDirty();
                        propertyData.setIDMContext((IVWIDMDocument)dialog.getSelectedItem());
                        ** break;
                    }
                }
                bAddNew = false;
            }
            catch (VWException ex) {
                VWMessageDialog.showOptionDialog(propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
                bAddNew = false;
                var13_10 = null;
                propertyData.restoreDefaultCursor();
                return bAddNew;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                bAddNew = false;
                var13_11 = null;
                propertyData.restoreDefaultCursor();
                return bAddNew;
            }
lbl56:
            // 1 sources

        }
        catch (Throwable var12_20) {
            var13_12 = null;
            propertyData.restoreDefaultCursor();
            throw var12_20;
        }
        var13_9 = null;
        propertyData.restoreDefaultCursor();
        return bAddNew;
    }

    private void addScenarioDefinition(VWScenarioDefinition newScenarioDef, boolean bAddWorkflows) {
        try {
            block7: {
                if (newScenarioDef == null) {
                    int nIndex = 1;
                    VWScenarioDefinition[] scenarioDefs = this.m_scenarioCollectionDef.getScenarios();
                    if (scenarioDefs != null) {
                        nIndex = scenarioDefs.length + 1;
                    }
                    while (true) {
                        try {
                            String defaultName = VWResource.s_defaultScenarioDefinitionNameTemplate.toString(Integer.toString(nIndex));
                            newScenarioDef = this.createScenarioDefinition(defaultName);
                            this.m_scenarioCollectionDef.addScenario(newScenarioDef);
                            break block7;
                        }
                        catch (VWException ex1) {
                            ++nIndex;
                            continue;
                        }
                        break;
                    }
                }
                this.m_scenarioCollectionDef.addScenario(newScenarioDef);
            }
            this.addDataItemToList(newScenarioDef, bAddWorkflows);
            this.setCollectionDirty();
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 725, newScenarioDef);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private VWScenarioDefinition createScenarioDefinition(String scenarioName) {
        try {
            VWScenarioDefinition scenarioDef = new VWScenarioDefinition();
            scenarioDef.setName(scenarioName);
            scenarioDef.setAnimationEnabled(true);
            scenarioDef.setCollectAnalysisData(true);
            Calendar start = Calendar.getInstance();
            start.set(10, 8);
            start.set(12, 0);
            start.set(13, 0);
            start.set(9, 0);
            scenarioDef.setStartTime(start.getTime());
            Calendar end = Calendar.getInstance();
            end.set(10, 5);
            end.set(12, 0);
            end.set(13, 0);
            end.set(9, 1);
            scenarioDef.setEndTime(end.getTime());
            return scenarioDef;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void reinitializeDataItemList() {
        try {
            VWScenarioDefinition[] scenarioDefs;
            this.m_propertyDataList = new Vector();
            if (this.m_scenarioCollectionDef != null && (scenarioDefs = this.m_scenarioCollectionDef.getScenarios()) != null) {
                for (int nIndex = 0; nIndex < scenarioDefs.length; ++nIndex) {
                    this.addDataItemToList(scenarioDefs[nIndex], false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addDataItemToList(VWScenarioDefinition scenarioDef, boolean bAddWorkflows) throws VWException {
        if (scenarioDef != null) {
            VWWorkflowCollectionDefinition wflCollDef;
            if (bAddWorkflows && (wflCollDef = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition()) != null && scenarioDef.getWorkflows() != null) {
                int nIndex;
                VWScenarioWorkflowDefinition[] wflDefs = scenarioDef.getWorkflows();
                for (nIndex = 0; nIndex < wflDefs.length; ++nIndex) {
                    if (!wflCollDef.isExistingWorkflowName(wflDefs[nIndex].getWorkflowDefinition().getName())) continue;
                    throw new VWException("vw.toolkit.design.canvas.simulation.DuplicateWorkflowName", "A workflow with the same name already exists.");
                }
                for (nIndex = 0; nIndex < wflDefs.length; ++nIndex) {
                    VWWorkflowDefinition newWflDef;
                    VWWorkflowDefinition origWflDef = wflDefs[nIndex].getWorkflowDefinition();
                    if (origWflDef == null || (newWflDef = (VWWorkflowDefinition)origWflDef.clone()) == null) continue;
                    newWflDef.setName(origWflDef.getName());
                    this.m_designerCoreData.getProcessMenuHelper().addWorkflowDefinition(newWflDef, this.m_designerCoreData.getDesignerPreferences());
                }
            }
            VWSIMPropertyData propertyData = new VWSIMPropertyData(this.m_parentFrame, this.m_designerCoreData.getSessionInfo());
            propertyData.setScenarioDefinition(scenarioDef, true);
            this.m_propertyDataList.addElement(propertyData);
        }
    }

    private void removeDataItemFromList(String scenarioName) {
        try {
            if (this.m_propertyDataList != null) {
                for (int nIndex = this.m_propertyDataList.size() - 1; nIndex >= 0; --nIndex) {
                    VWSIMPropertyData dataItem = this.m_propertyDataList.elementAt(nIndex);
                    if (dataItem == null || VWStringUtils.compare(scenarioName, dataItem.getScenarioDefinition().getName()) != 0) continue;
                    this.m_propertyDataList.removeElementAt(nIndex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWSIMPropertyData findDataItemInList(String scenarioName) {
        try {
            if (this.m_propertyDataList != null) {
                for (int nIndex = this.m_propertyDataList.size() - 1; nIndex >= 0; --nIndex) {
                    VWSIMPropertyData dataItem = this.m_propertyDataList.elementAt(nIndex);
                    if (dataItem == null || VWStringUtils.compare(scenarioName, dataItem.getScenarioDefinition().getName()) != 0) continue;
                    return dataItem;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFileNETSaveItemAction(VWSIMPropertyData propertyData) {
        block7: {
            try {
                block6: {
                    try {
                        propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
                        VWScenarioDefinition scenarioDefinition = propertyData.getScenarioDefinition();
                        IVWIDMDocument idmDoc = (IVWIDMDocument)propertyData.getIDMContext();
                        if (scenarioDefinition == null || idmDoc == null || !idmDoc.isCheckedOut() || !idmDoc.canCheckin()) break block6;
                        propertyData.displayWaitCursor();
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        scenarioDefinition.write(outStream);
                        byte[] fileContents = outStream.toByteArray();
                        outStream.close();
                        String name = scenarioDefinition.getName();
                        if (name == null) {
                            name = "";
                        }
                        idmDoc.saveContents(fileContents, name);
                        propertyData.resetDirty();
                    }
                    catch (VWException ex) {
                        VWMessageDialog.showOptionDialog(propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
                        Object var8_10 = null;
                        propertyData.restoreDefaultCursor();
                        break block7;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var8_11 = null;
                        propertyData.restoreDefaultCursor();
                    }
                }
                Object var8_9 = null;
                propertyData.restoreDefaultCursor();
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                propertyData.restoreDefaultCursor();
                throw throwable;
            }
        }
    }
}

